<?php



/**

  * PDF generation for admin, pdf.php

  * @category admin

  *

  * @author PrestaShop <support@prestashop.com>

  * @copyright PrestaShop

  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0

  * @version 1.0

  *

  */



define('PS_ADMIN_DIR', getcwd());



include(PS_ADMIN_DIR.'/../config/config.inc.php');



/* Header can't be included, so cookie must be created here */

$cookie = new Cookie('psAdmin');

if (!$cookie->id_employee)

	Tools::redirect('login.php');



if (isset($_GET['pdf']))

{

	if (!isset($_GET['id_order']))

		die (Tools::displayError('order id is missing'));

	$order = new Order(intval($_GET['id_order']));

	if (!Validate::isLoadedObject($order))

		die(Tools::displayError('cannot find order in database'));

	PDF::invoice($order);

}

elseif (isset($_GET['id_order_slip']))

{

	$orderSlip = new OrderSlip(intval($_GET['id_order_slip']));

	$order = new Order(intval($orderSlip->id_order));

	if (!Validate::isLoadedObject($order))

		die(Tools::displayError('cannot find order in database'));

	$order->products = OrderSlip::getOrdersSlipProducts($orderSlip->id, $order);

	$tmp = NULL;

	PDF::invoice($order, 'D', false, $tmp, $orderSlip);

}

elseif (isset($_GET['orders']))

{

	$orders = unserialize(urldecode($_GET['orders']));

	if (is_array($orders))

		PDF::multipleInvoices($orders);

}



?>