<?php



class AdminPrintPDF extends AdminTab

{

	public function displayForm()

	{

		global $currentIndex;

		

		$output = '

		<h2>'.$this->l('Print PDF invoices').'</h2>

		<fieldset class="width2">

			<form action="'.$currentIndex.'&submitPrint=1&token='.$this->token.'" method="post">

				<label>'.$this->l('From:').' </label>

				<div class="margin-form">

					<input type="text" size="4" maxlength="10" name="date_from" style="width: 120px;" /> <sup>*</sup>

					<p style="clear: both;">'.$this->l('Format: 2007-12-31 (inclusive)').'</p>

				</div>

				<label>'.$this->l('To:').' </label>

				<div class="margin-form">

					<input type="text" size="4" maxlength="10" name="date_to" value="'.(date('Y-m-d')).'" style="width: 120px;" /> <sup>*</sup>

					<p style="clear: both;">'.$this->l('Format: 2008-12-31 (inclusive)').'</p>

				</div>

				<div class="margin-form">

					<input type="submit" value="'.$this->l('Generate PDF file').'" name="submitPrint" class="button" />

				</div>

				<div class="small"><sup>*</sup> '.$this->l('Required fields').'</div>

			</form>

		</fieldset>';

		

		echo $output;

	}

	

	public function display()

	{

		$this->displayForm();

	}

	

	public function postProcess()

	{

		global $currentIndex;

		

		if(Tools::getValue('submitPrint'))

		{

			if (!Validate::isDate($_POST['date_from']))

				$this->_errors[] = $this->l('Invalid from date');

			if (!Validate::isDate($_POST['date_to']))

				$this->_errors[] = $this->l('Invalid end date');

			if (!sizeof($this->_errors))

			{

				$orders = Order::getOrdersIdByDate($_POST['date_from'], $_POST['date_to']);

				if (sizeof($orders))

					Tools::redirectAdmin('pdf.php?orders='.urlencode(serialize($orders)).'&token='.$this->token);

				else

					$this->_errors[] = $this->l('No orders placed for this period');

			}			

		}

		else

			parent::postProcess();

	}

}



?>