<?php

/**
  * Gender class, Gender.php
  * Genders management
  * @category classes
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 1.0
  *
  */
  
class		Gender extends ObjectModel
{
	public 		$id;
	
	/** @var string Official iso code */
	public 		$iso_code;
	
	/** @var string Name */
	public 		$name;
	
	protected	$fieldsRequired = array('iso_code', 'name');
	protected	$fieldsSize = array('iso_code' => 2, 'name' => 32);
	protected	$fieldsValidate = array('iso_code' => 'isGenderIsoCode', 'name' => 'isGenderName');
	
	protected 	$table = 'gender';
	protected 	$identifier = 'id_gender';
	
	public	function getFields()
	{
		parent::validateFields();
		$fields['iso_code'] = pSQL($this->iso_code);
		$fields['name'] = pSQL($this->name);
		return $fields;
	}
	
	/**
	  * Get gender from a customer ID
	  *
	  * @param string $id_customer Customer ID
	  * @return string gender
	  */
	static public function getNameById($id_customer)
	{
		$db = Db::getInstance();        
		$result = $db->getRow('
		SELECT g.`name`
		FROM `'._DB_PREFIX_.'gender` g
		LEFT JOIN `'._DB_PREFIX_.'customer` c ON c.`id_gender` = g.`id_gender`
		WHERE c.`id_customer` = '.intval($id_customer));

		return ($result ? substr($result['name'], 0, 1) : false);
	}
}

?>
