/*----------------------------------------------------------------------------\

|                               Tab Pane 1.02                                 |

|-----------------------------------------------------------------------------|

|                         Created by Erik Arvidsson                           |

|                  (http://webfx.eae.net/contact.html#erik)                   |

|                      For WebFX (http://webfx.eae.net/)                      |

|-----------------------------------------------------------------------------|

|                Copyright (c) 2002, 2003, 2006 Erik Arvidsson                |

|-----------------------------------------------------------------------------|

| Licensed under the Apache License, Version 2.0 (the "License"); you may not |

| use this file except in compliance with the License.  You may obtain a copy |

| of the License at http://www.apache.org/licenses/LICENSE-2.0                |

| - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - |

| Unless  required  by  applicable law or  agreed  to  in  writing,  software |

| distributed under the License is distributed on an  "AS IS" BASIS,  WITHOUT |

| WARRANTIES OR  CONDITIONS OF ANY KIND,  either express or implied.  See the |

| License  for the  specific language  governing permissions  and limitations |

| under the License.                                                          |

\----------------------------------------------------------------------------*/



function hasSupport() {



	if (typeof hasSupport.support != "undefined")

		return hasSupport.support;

	

	var ie55 = /msie 5\.[56789]/i.test( navigator.userAgent );

	

	hasSupport.support = ( typeof document.implementation != "undefined" &&

			document.implementation.hasFeature( "html", "1.0" ) || ie55 )

			

	// IE55 has a serious DOM1 bug... Patch it!

	if ( ie55 ) {

		document._getElementsByTagName = document.getElementsByTagName;

		document.getElementsByTagName = function ( sTagName ) {

			if ( sTagName == "*" )

				return document.all;

			else

				return document._getElementsByTagName( sTagName );

		};

	}



	return hasSupport.support;

}



function WebFXTabPane( el ) {

	if ( !hasSupport() || el == null ) return;

	

	this.element = el;

	this.element.tabPane = this;

	this.pages = [];

	this.selectedIndex = null;

	

	// add class name tag to class name

	this.element.className = this.classNameTag + " " + this.element.className;

	

	// add tab row

	this.tabRow = document.createElement( "div" );

	this.tabRow.className = "tab-row";

	el.insertBefore( this.tabRow, el.firstChild );



	var tabIndex = pos_select;

	this.selectedIndex = tabIndex;

	

	// loop through child nodes and add them

	var cs = el.childNodes;

	var n;

	for (var i = 0; i < cs.length; i++) {

		if (cs[i].nodeType == 1 && cs[i].className == "tab-page") {

			this.addTabPage( cs[i] );

		}

	}

}



WebFXTabPane.prototype.classNameTag = "dynamic-tab-pane-control";



WebFXTabPane.prototype.setSelectedIndex = function ( n ) {

	if (this.selectedIndex != n) {

		if (this.selectedIndex != null && this.pages[ this.selectedIndex ] != null )

			this.pages[ this.selectedIndex ].hide();

		this.selectedIndex = n;

		this.pages[ this.selectedIndex ].show();

	}

};

	

WebFXTabPane.prototype.getSelectedIndex = function () {

	return this.selectedIndex;

};

	

WebFXTabPane.prototype.addTabPage = function ( oElement ) {

	if ( !hasSupport() ) return;

	

	if ( oElement.tabPage == this )	// already added

		return oElement.tabPage;



	var n = this.pages.length;

	var tp = this.pages[n] = new WebFXTabPage( oElement, this, n );

	tp.tabPane = this;

	

	// move the tab out of the box

	this.tabRow.appendChild( tp.tab );

			

	if ( n == this.selectedIndex )

		tp.show();

	else

		tp.hide();

		

	return tp;

};

	

WebFXTabPane.prototype.dispose = function () {

	this.element.tabPane = null;

	this.element = null;		

	this.tabRow = null;

	

	for (var i = 0; i < this.pages.length; i++) {

		this.pages[i].dispose();

		this.pages[i] = null;

	}

	this.pages = null;

};



function WebFXTabPage( el, tabPane, nIndex ) {

	if ( !hasSupport() || el == null ) return;

	

	this.element = el;

	this.element.tabPage = this;

	this.index = nIndex;

	

	var cs = el.childNodes;

	for (var i = 0; i < cs.length; i++) {

		if (cs[i].nodeType == 1 && cs[i].className == "tab") {

			this.tab = cs[i];

			break;

		}

	}

	

	var a = document.createElement( "A" );

	this.aElement = a;

	a.href = "#";

	a.onclick = function () { return false; };

	while ( this.tab.hasChildNodes() )

		a.appendChild( this.tab.firstChild );

	this.tab.appendChild( a );



	var oThis = this;

	this.tab.onclick = function () { oThis.select(); };

	this.tab.onmouseover = function () { WebFXTabPage.tabOver( oThis ); };

	this.tab.onmouseout = function () { WebFXTabPage.tabOut( oThis ); };

}



WebFXTabPage.prototype.show = function () {

	var el = this.tab;

	var s = el.className + " selected";

	s = s.replace(/ +/g, " ");

	el.className = s;

	

	this.element.style.display = "block";

	pos_select = this.element.id.substring(4, 5) - 1;

	document.getElementById('tabs').value = pos_select;

};



WebFXTabPage.prototype.hide = function () {

	var el = this.tab;

	var s = el.className;

	s = s.replace(/ selected/g, "");

	el.className = s;



	this.element.style.display = "none";

};

	

WebFXTabPage.prototype.select = function () {

	this.tabPane.setSelectedIndex( this.index );

};

	

WebFXTabPage.prototype.dispose = function () {

	this.aElement.onclick = null;

	this.aElement = null;

	this.element.tabPage = null;

	this.tab.onclick = null;

	this.tab.onmouseover = null;

	this.tab.onmouseout = null;

	this.tab = null;

	this.tabPane = null;

	this.element = null;

};



WebFXTabPage.tabOver = function ( tabpage ) {

	var el = tabpage.tab;

	var s = el.className + " hover";

	s = s.replace(/ +/g, " ");

	el.className = s;

};



WebFXTabPage.tabOut = function ( tabpage ) {

	var el = tabpage.tab;

	var s = el.className;

	s = s.replace(/ hover/g, "");

	el.className = s;

};





// This function initializes all uninitialized tab panes and tab pages

function setupAllTabs() {

	if ( !hasSupport() ) return;



	var all = document.getElementsByTagName( "*" );

	var l = all.length;

	var tabPaneRe = /tab\-pane/;

	var tabPageRe = /tab\-page/;

	var cn, el;

	var parentTabPane;

	

	for ( var i = 0; i < l; i++ ) {

		el = all[i]

		cn = el.className;



		// no className

		if ( cn == "" ) continue;

		

		// uninitiated tab pane

		if ( tabPaneRe.test( cn ) && !el.tabPane )

			new WebFXTabPane( el );

	

		// unitiated tab page wit a valid tab pane parent

		else if ( tabPageRe.test( cn ) && !el.tabPage &&

					tabPaneRe.test( el.parentNode.className ) ) {

			el.parentNode.tabPane.addTabPage( el );			

		}

	}

}



function disposeAllTabs() {

	if ( !hasSupport() ) return;

	

	var all = document.getElementsByTagName( "*" );

	var l = all.length;

	var tabPaneRe = /tab\-pane/;

	var cn, el;

	var tabPanes = [];

	

	for ( var i = 0; i < l; i++ ) {

		el = all[i]

		cn = el.className;



		// no className

		if ( cn == "" ) continue;

		

		// tab pane

		if ( tabPaneRe.test( cn ) && el.tabPane )

			tabPanes[tabPanes.length] = el.tabPane;

	}

	

	for (var i = tabPanes.length - 1; i >= 0; i--) {

		tabPanes[i].dispose();

		tabPanes[i] = null;

	}

}



// Select the right tabs

if (!pos_select)

	pos_select = 0;



// DOM2

if ( typeof window.addEventListener != "undefined" )

	window.addEventListener( "load", setupAllTabs, false );



// IE 

else if ( typeof window.attachEvent != "undefined" ) {

	window.attachEvent( "onload", setupAllTabs );

	window.attachEvent( "onunload", disposeAllTabs );

}



else {

	if ( window.onload != null ) {

		var oldOnload = window.onload;

		window.onload = function ( e ) {

			oldOnload( e );

			setupAllTabs();

		};

	}

	else 

		window.onload = setupAllTabs;

}