<?php



class BlockUserInfo extends Module

{

	function __construct()

	{

		$this->name = 'blockuserinfo';

		$this->tab = 'Blocks';

		$this->version = 0.1;



		parent::__construct(); // The parent construct is required for translations



		$this->page = basename(__FILE__, '.php');

		$this->displayName = $this->l('User info block');

		$this->description = $this->l('Adds a block that displays information about the customer');

	}



	function install()

	{

		if (!parent::install())

			return false;

		if (!$this->registerHook('top'))

			return false;

		return true;

	}



	/**

	* Returns module content for header

	*

	* @param array $params Parameters

	* @return string Content

	*/

	function hookTop($params)

	{

		global $smarty, $cookie, $cart;

		$smarty->assign(array(

			'cart' => $cart,

			'cart_qties' => $cart->nbProducts(),

			'logged' => $cookie->isLogged(),

			'customerName' => ($cookie->logged ? $cookie->customer_firstname.' '.$cookie->customer_lastname : false)

		));

		return $this->display(__FILE__, 'blockuserinfo.tpl');

	}

}



?>

