<?php
/*
Module dvelopp par l'quipe de Magavenue. Pour plus d'informations, rendez-vous sur notre blog  l'adresse : http://magavenue.com/blog.
Pour nous contacter, merci d'utiliser le formulaire de contact sur notre blog  l'adresse : http://magavenue.com/blog.
*/
include(dirname(__FILE__).'/../../config/config.inc.php');
require_once(dirname(__FILE__).'/../../init.php');


//cat
$category = new Category(intval(Tools::getValue('id_category')), intval($cookie->id_lang));
$category->name = Category::hideCategoryPosition($category->name);
$category->description = nl2br2($category->description);
$nbProducts = $category->getProducts(NULL, NULL, NULL, $orderBy, $orderWay, true);
//fin cat

// Get data
$number = (intval(Tools::getValue('n')) ? intval(Tools::getValue('n')) : 10);
$orderByValues = array(0 => 'name', 1 => 'price', 2 => 'date_add', 3 => 'date_upd', 4 => 'position');
$orderWayValues = array(0 => 'ASC', 1 => 'DESC');
$orderBy = Tools::strtolower(Tools::getValue('orderby', $orderByValues[intval(Configuration::get('PS_PRODUCTS_ORDER_BY'))]));
$orderWay = Tools::strtoupper(Tools::getValue('orderway', $orderWayValues[intval(Configuration::get('PS_PRODUCTS_ORDER_WAY'))]));
if (!in_array($orderBy, $orderByValues))
	$orderBy = $orderByValues[0];
if (!in_array($orderWay, $orderWayValues))
	$orderWay = $orderWayValues[0];
$products = Product::getProducts(intval($cookie->id_lang), 0, ($number > 10 ? 10 : $number), $orderBy, $orderWay, intval(Tools::getValue('id_category')));
$currency = new Currency(intval($cookie->id_currency));
$affiliate = (Tools::getValue('ac') ? '?ac='.Tools::getValue('ac') : '');

// Send feed
header("Content-Type:text/xml; charset=utf-8");
echo '<?xml version="1.0" encoding="UTF-8"?>'."\n";
?>
<rss version="2.0">
	<channel>
		<title><![CDATA[<?php echo Configuration::get('PS_SHOP_NAME') ?>]]></title>
		<link><?php echo 'http://'.htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').__PS_BASE_URI__; ?></link>
		<mail><?php echo Configuration::get('PS_SHOP_EMAIL') ?></mail>
		<generator>Magavenue</generator>
		<language><?php echo Language::getIsoById(intval($cookie->id_lang)); ?></language>
		<categorie><?php echo $category->name; ?></categorie>
		<categoriedesc><?php echo $category->description; ?></categoriedesc>
		<categorienbr><?php echo $nbProducts; ?></categorienbr>
		<categorieimg><?php echo $category->id_image; ?></categorieimg>

<?php
	foreach ($products AS $product)
	{
        $image = Image::getImages(intval($cookie->id_lang), $product['id_product']);
		echo "\t\t<item>\n
		      \t\t\t<title><![CDATA[".$product['name']." ]]></title>\n
	          \t\t\t<id><![CDATA[".$product['id_product']." ]]></id>\n
		      \t\t\t<description>&lt;img src=&quot;http://".htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').__PS_BASE_URI__."img/p/".$image[0]['id_product']."-".$image[0]['id_image']."-large.jpg&quot; title=&quot;".$product['name']."&quot; alt=&quot;thumb&quot; /&gt;
		<![CDATA[".$product['description_short']."]]></description>\n
		      \t\t\t<link><![CDATA[/boutique_prestashop/produit.php?product=".$product['id_product']."]]></link>\n";
        //en cas de reduction
        if (($product['reduction_price'] != 0 || $product['reduction_percent'] != 0)&& (($product['reduction_from'] == $product['reduction_to'])||(date("Y-m-d") <= $product['reduction_to']) && (date("Y-m-d") >= $product['reduction_from'])))
              echo"\t\t\t<solde><![CDATA[reduction]]></solde>\n";
		      echo"\t\t\t<prix><![CDATA[".Tools::displayPrice(Product::getPriceStatic($product['id_product']), $currency)."]]></prix>\n
		      \t\t\t<dispo><![CDATA[".$product['quantity']."]]></dispo>\n
		      \t\t</item>\n";
	}
?>
	</channel>
</rss>