<?php



include(dirname(__FILE__).'/config/config.inc.php');

include(dirname(__FILE__).'/header.php');



define('MIN_PASSWD_LENGTH', 8);

$errors = array();



if (Tools::isSubmit('email'))

{

    if (!($email = Tools::getValue('email')) OR !Validate::isEmail($email))

        $errors[] = Tools::displayError('invalid e-mail address');

    else

    {

        $customer = new Customer();

        $customer->getByemail($email);

        if (!Validate::isLoadedObject($customer))

            $errors[] = Tools::displayError('there is no account registered to this e-mail address');

		else

		{

		    $customer->passwd = Tools::encrypt($password = Tools::passwdGen(MIN_PASSWD_LENGTH));

	        if ($customer->update())

			{

				Mail::Send(intval($cookie->id_lang), 'password', 'Your password', 

				array('{email}' => $customer->email, 

				'{lastname}' => $customer->lastname, 

				'{firstname}' => $customer->firstname, 

				'{passwd}' => $password), 

				$customer->email, 

				$customer->firstname.' '.$customer->lastname);

				$smarty->assign(array(

				'confirmation' => 1,

				'email' => $customer->email));

			}

			else

				$errors[] = Tools::displayError('error with your account and your new password cannot be sent to your e-mail; please report your problem using the contact form');

		}

    }

}



$smarty->assign('errors', $errors);

Tools::safePostVars();

$smarty->display(_PS_THEME_DIR_.'password.tpl');



include(dirname(__FILE__).'/footer.php');



?>