<?php

include(dirname(__FILE__).'/config/config.inc.php');



//CSS ans JS file calls

$css_files = array(

	__PS_BASE_URI__.'css/thickbox.css' => 'all'

);

$js_files = array(

	__PS_BASE_URI__.'js/jquery/thickbox-modified.js',

	__PS_BASE_URI__.'js/jquery/jquery.idTabs.modified.js',

	__PS_BASE_URI__.'js/jquery/jquery.scrollto.js',

	__PS_BASE_URI__.'js/jquery/jquery.serialScroll.js',

	_THEME_JS_DIR_.'tools.js',

	_THEME_JS_DIR_.'product.js'

);



include_once(dirname(__FILE__).'/header.php');

$errors = array();



if (!isset($_GET['id_product']) OR !Validate::isUnsignedId($_GET['id_product']))

	$errors[] = Tools::displayError('product not found');

else

{

	$cookie = new Cookie('ps');

	Tools::setCookieLanguage();

	$product = new Product(intval($_GET['id_product']), true, intval($cookie->id_lang));

	if (!Validate::isLoadedObject($product) OR !$product->active)

		$errors[] = Tools::displayError('product is no longer available');

	else

	{

		$productPriceWithTax = $product->getPrice(true, NULL, 2);

		$productPriceWithoutEcoTax = $productPriceWithTax - $product->ecotax;

		$configs = Configuration::getMultiple(array('PS_ORDER_OUT_OF_STOCK', 'PS_LAST_QTIES'));





		/* Features / Values */

		$features = $product->getFrontFeatures(intval($cookie->id_lang));

		

		/* Category */

		if (isset($_SERVER['HTTP_REFERER']) AND ereg('^(.*)\/([0-9]+)\-(.*[^\.])|(.*)id_category=([0-9]+)(.*)$', $_SERVER['HTTP_REFERER'], $regs) AND !strstr($_SERVER['HTTP_REFERER'], '.html'))

		{

			if (isset($regs[2]) AND is_numeric($regs[2]))

			{

				$category = new Category(intval($regs[2]), intval($cookie->id_lang));

			}

			elseif (isset($regs[5]) AND is_numeric($regs[5]))

			{

				$category = new Category(intval($regs[5]), intval($cookie->id_lang));

			}

		}

		else

		{

			$category = new Category($product->id_category_default, intval($cookie->id_lang));

		}

		if (isset($category) AND is_object($category) AND $category->id)

		{

			$smarty->assign(array(

			'category' => $category,

			'subCategories' => $category->getSubCategories(intval($cookie->id_lang), true),

			'id_category_current' => intval($category->id),

			'id_category_parent' => intval($category->id_parent),

			'return_category_name' => Tools::safeOutput(Category::hideCategoryPosition($category->name))));

		}

		$smarty->assign(array(

			'return_link' => (isset($category->id) AND $category->id) ? Tools::safeOutput($link->getCategoryLink($category)) : 'javascript: history.back();',

			'path' => (isset($category->id) AND $category->id) ? Tools::getPath($category->id, $product->name) : Tools::getPath($product->id_category_default, $product->name)

		));





		/* Quantity discount management */

		$quantityDiscounts = QuantityDiscount::getQuantityDiscounts($product->id, $product->getPriceWithoutReduct());

        foreach ($quantityDiscounts AS &$qd)

            $qd['price'] = $productPriceWithTax - $qd['real_value'];



		/* Get manufacturer infos */

		$product_manufacturer = new Manufacturer($product->id_manufacturer);



		/* /Quantity discount management */

		$smarty->assign(array(

			'quantity_discounts' => $quantityDiscounts,

			'product' => $product,

			'product_manufacturer' => $product_manufacturer,

			'token' => Tools::getToken(false),

			'productPriceWithoutEcoTax' => ($productPriceWithTax - $product->ecotax),

			'features' => $product->getFrontFeatures(intval($cookie->id_lang)),

			'allow_oosp' => $product->isAvailableWhenOutOfStock($product->out_of_stock),

			'last_qties' =>  intval($configs['PS_LAST_QTIES']),

			'col_img_dir' => _PS_COL_IMG_DIR_,

			'HOOK_EXTRA' => Module::hookExec('extra'),

			'HOOK_PRODUCT_FOOTER' => Hook::productFooter($product, $category),

			'HOOK_PRODUCT_TAB' =>  Module::hookExec('productTab'),

			'HOOK_PRODUCT_TAB_CONTENT' =>  Module::hookExec('productTabContent')

		));

		

		$images = $product->getImages(intval($cookie->id_lang));

		$productImages = array();

		foreach ($images AS $k => $image)

		{

			if ($image['cover'])

			{

				$smarty->assign('mainImage', $images[0]);

				$cover = $image;

				$cover['id_image'] = intval($product->id).'-'.$cover['id_image'];

				$cover['id_image_only'] = $image['id_image'];

			}

			$productImages[$image['id_image']] = $image;

		}

		if (!isset($cover))

			$cover = array('id_image' => Language::getIsoById($cookie->id_lang).'-default', 'legend' => 'No picture', 'title' => 'No picture');

		$size = Image::getSize('large');



		$smarty->assign(array(

			'cover' => $cover,

			'imgWidth' => intval($size['width']),

			'accessories' => $product->getAccessories(intval($cookie->id_lang))));

		if (sizeof($productImages))

			$smarty->assign('images', $productImages);



		/* Attributes / Groups & colors */

		$colors = array();

		$attributesGroups = $product->getAttributesGroups(intval($cookie->id_lang));

		if (Db::getInstance()->numRows())

		{

			foreach ($attributesGroups AS $k => $row)

			{

				/* Color management */

				if (isset($row['attribute_color']) AND $row['attribute_color'] AND $row['id_attribute_group'] == $product->id_color_default)

				{

					$colors[$row['id_attribute']]['value'] = $row['attribute_color'];

					$colors[$row['id_attribute']]['name'] = $row['attribute_name'];

				}



				$groups[$row['id_attribute_group']]['attributes'][$row['id_attribute']] = $row['attribute_name'];

				$groups[$row['id_attribute_group']]['name'] = $row['public_group_name'];

				if ($row['default_on'])

					$groups[$row['id_attribute_group']]['default'] = intval($row['id_attribute']);



				$combinaisons[$row['id_product_attribute']]['attributes_values'][$row['id_attribute_group']] = $row['attribute_name'];

				$combinations[$row['id_product_attribute']]['attributes'][] = intval($row['id_attribute']);

				$combinations[$row['id_product_attribute']]['price'] = $row['price'];

				$combinations[$row['id_product_attribute']]['ecotax'] = $row['ecotax'];

				$combinations[$row['id_product_attribute']]['weight'] = $row['weight'];

				$combinations[$row['id_product_attribute']]['quantity'] = intval($row['quantity']);

				$combinations[$row['id_product_attribute']]['reference'] = $row['reference'];

				$combinations[$row['id_product_attribute']]['id_image'] = (($row['id_image'] != NULL) ? intval($row['id_image']) : -1);

			}

			foreach ($combinations AS $id_product_attribute => $comb)

			{

				$attributeList = '';

				foreach ($comb['attributes'] AS $id_attribute)

					$attributeList .= '\''.intval($id_attribute).'\',';

				$attributeList = rtrim($attributeList, ',');

				$combinations[$id_product_attribute]['list'] = $attributeList;

			}



			$smarty->assign(array(

				'groups' => $groups,

				'combinaisons' => $combinations, /* Kept for compatibility purpose only */

				'combinations' => $combinations,

				'colors' => (sizeof($colors) AND $product->id_color_default) ? $colors : false));

		}

		$smarty->assign('no_tax', Tax::excludeTaxeOption() OR !Tax::getApplicableTax(intval($product->id_tax), 1 /* fake */));

	}

}

$smarty->assign(array(

	'ENT_NOQUOTES' => ENT_NOQUOTES,

	'outOfStockAllowed' => Configuration::get('PS_ORDER_OUT_OF_STOCK'),

	'displayPreTax' => Configuration::get('PS_DISPLAY_WITHOUT_TAX'),

	'errors' => $errors,

	'categories' => Category::getHomeCategories(intval($cookie->id_lang)),

	'have_image' => Product::getCover(intval(Tools::getValue('id_product'))),

	'display_qties' => Configuration::get('PS_DISPLAY_QTIES'),

	'display_ht' => !Tax::excludeTaxeOption(),

	));



if (file_exists(_PS_THEME_DIR_.'thickbox.tpl'))

	$smarty->display(_PS_THEME_DIR_.'thickbox.tpl');

	$smarty->assign('currencySign', $currency->sign);

	$smarty->assign('currencyRate', $currency->conversion_rate);

	$smarty->assign('currencyFormat', $currency->format);



	$smarty->display(_PS_THEME_DIR_.'product.tpl');



include(dirname(__FILE__).'/footer.php');



?>

